<?php

namespace App\Entities\Tally\Management;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Period extends Model 
{

    protected $table = 'periods';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('allowed', 'work_team_id');
    protected $fillable = array('begin', 'end');

    public function slots()
    {
        return $this->hasMany('App\Entities\Tally\Work\Slot', 'slot_ids');
    }

}